import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

const ConfirmCodeBtn = (props) => (
    <div className='phone__code-btn'>
        {props.status !== 'valid' && (
            <Button view='pseudo' size='l' width='max' onClick={props.checkCode}>
                {i18n('_AUTH_.confirm_code')}
            </Button>
        )}

        {props.status === 'valid' && <span>{i18n('Frontend.phone-confirm_message_confirmed')}</span>}
    </div>
);

ConfirmCodeBtn.propTypes = {
    status: PropTypes.string.isRequired,
    checkCode: PropTypes.func.isRequired
};

export default ConfirmCodeBtn;
