import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

class CountDown extends Component {
    constructor(props) {
        super(props);

        this.state = {
            countdown: props.confirmationRetryCountdown
        };
    }

    componentDidMount() {
        this.startTimer();
    }

    componentDidUpdate(prevProps) {
        if (prevProps.restartTrigger !== this.props.restartTrigger) {
            clearInterval(this.intervalId);
            this.startTimer();
        }
    }

    componentWillUnmount() {
        clearInterval(this.intervalId);
    }

    startTimer() {
        let countdown = this.state.countdown;
        const {showCodeHint, updateCodeStatus} = this.props;

        this.intervalId = setInterval(
            function() {
                this.setState({
                    countdown: (countdown -= 1)
                });

                if (countdown === 0) {
                    clearInterval(this.intervalId);
                    if (showCodeHint) {
                        showCodeHint(true);
                    }
                    if (updateCodeStatus) {
                        updateCodeStatus();
                    }
                }
            }.bind(this),
            1000
        );
    }

    render() {
        const countdown = this.state.countdown;

        if (countdown === 0) {
            return null;
        }

        const minutes = Math.floor(countdown / 60);
        const seconds = countdown - 60 * minutes;

        return (
            <span
                className={classnames('send-code__countdown', {
                    'send-code__countdown_hidden': this.state.countdown === 0
                })}
            >
                {`0${minutes}`.slice(-2)}:{`0${seconds}`.slice(-2)}
            </span>
        );
    }
}

CountDown.defaultProps = {
    confirmationRetryCountdown: 30
};

CountDown.propTypes = {
    showCodeHint: PropTypes.func,
    updateCodeStatus: PropTypes.func,
    restartTrigger: PropTypes.bool,
    confirmationRetryCountdown: PropTypes.number.isRequired
};

export default CountDown;
