import React from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';

const FieldDescriptionText = (props) => {
    const {
        isPhoneCallConfirmation,
        isDiscardCallConfirmation,
        callingNumberTemplate,
        changeNumber,
        changeText,
        isMobile
    } = props;

    let codeSentMessage;

    if (isPhoneCallConfirmation) {
        codeSentMessage = isDiscardCallConfirmation
            ? i18n('Frontend.discard_call_confirmation.description').replace('%s', callingNumberTemplate)
            : `${i18n('Frontend.confirmation_call_again')} ${i18n('Frontend.confirmation_call_hear_text')}`;
    } else {
        codeSentMessage = changeText ? i18n('Frontend.code_send_again') : i18n('Frontend.phone_code_send');
    }

    return (
        <div className='form__field'>
            {!isMobile && (
                <div className='registration__pseudo-link'>
                    <Link onClick={changeNumber}>{i18n('Frontend.phone_change_number')}</Link>
                </div>
            )}
            <span className='registration__form-text' dangerouslySetInnerHTML={{__html: codeSentMessage}} />
        </div>
    );
};

FieldDescriptionText.propTypes = {
    isPhoneCallConfirmation: PropTypes.bool.isRequired,
    isDiscardCallConfirmation: PropTypes.bool.isRequired,
    changeText: PropTypes.bool.isRequired,
    changeNumber: PropTypes.func.isRequired,
    callingNumberTemplate: PropTypes.string,
    isMobile: PropTypes.bool
};

export default FieldDescriptionText;
