import React from 'react';
import PropTypes from 'prop-types';
import {v4} from 'uuid';
import classnames from 'classnames';
import FieldPopup from '../../../desktop/errorPopup/error_popup.jsx';
import {Button} from '@components/Button';
import {Link} from '@components/Link';

export const PhoneErrorPopup = (props) => (
    <FieldPopup fieldName={props.field} visible={Boolean(props.isMobile && props.error && props.error.phone)}>
        {props.error && props.error.hasOwnProperty(props.field) && (
            <div className='form__popup-error' data-t={`${props.field}-error`} role='alert'>
                <div className='error-message'>{props.error && props.error[props.field].text}</div>
            </div>
        )}
    </FieldPopup>
);

PhoneErrorPopup.propTypes = {
    field: PropTypes.string,
    error: PropTypes.object,
    isMobile: PropTypes.bool
};

export const PhoneHintPopup = (props) => (
    <FieldPopup visible={props.showHint}>
        <div className='form__popup-text'>
            <h4 className='hint__title'>{props.hint.title}</h4>
            <div dangerouslySetInnerHTML={{__html: props.hint.text}} />
        </div>
    </FieldPopup>
);

PhoneHintPopup.propTypes = {
    showHint: PropTypes.bool.isRequired,
    field: PropTypes.object,
    hint: PropTypes.object.isRequired
};

export const SendCodeHintPopup = (props) => (
    <FieldPopup visible={props.showHint} fieldName='phone'>
        <div
            className={classnames({
                'form__popup-text': !props.isMobile,
                'form__mobile-text': props.isMobile
            })}
        >
            {props.error && props.error.length > 0 && !props.isMobile && (
                <div className='error-message error-message_hint' role='alert'>
                    {props.error}
                </div>
            )}

            <h4 className='hint__title'>{props.hint.title}</h4>

            {props.hint.text && <div dangerouslySetInnerHTML={{__html: props.hint.text}} />}

            <PhoneHintLinks isMobile={props.isMobile} hint={props.hint} canResendCode={props.canResendCode} />
        </div>
    </FieldPopup>
);

SendCodeHintPopup.propTypes = {
    showHint: PropTypes.bool.isRequired,
    hint: PropTypes.object.isRequired,
    code: PropTypes.string,
    setCodeSentStatus: PropTypes.func.isRequired,
    error: PropTypes.string.isRequired,
    canResendCode: PropTypes.bool.isRequired,
    isMobile: PropTypes.bool
};

const PhoneHintLinks = (props) => (
    <div>
        {props.hint.links.map((link, index) => {
            const linkClass =
                !props.canResendCode && index === 0
                    ? 'registration__pseudo-link link-disabled'
                    : 'registration__pseudo-link';

            if (props.isMobile) {
                if (!props.canResendCode && index === 0) {
                    return null;
                }
                return (
                    <div className='hint-btn'>
                        <Button view='pseudo' size='m' width='max' onClick={link.method} key={v4()}>
                            {link.text}
                        </Button>
                    </div>
                );
            }

            return (
                <div className={linkClass} key={v4()}>
                    <Link onClick={link.method}>{link.text}</Link>
                </div>
            );
        })}
    </div>
);

PhoneHintLinks.propTypes = {
    hint: PropTypes.object,
    canResendCode: PropTypes.bool,
    isMobile: PropTypes.bool
};
