import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import Component from './send_code_btns';

const mapStateToProps = (state = {}) => {
    const {
        customs: {hideRegistration: {noPhoneLink = false} = {}} = {},
        common: {origin = null} = {},
        registrationName
    } = state;

    return {
        hideNoPhoneLink:
            (registrationName === 'complete' && !hasExp(state, 'exp-no-phone-auth-complete')) ||
            noPhoneLink ||
            (!origin && hasExp(state, 'exp-registration-no-phone-link-no-origin'))
    };
};

export const SendCodeBtns = connect(mapStateToProps)(Component);
