import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Button} from '@components/Button';
import {Link} from '@components/Link';
import {Spin} from '@components/Spin';
import processPhoneData from '../../../../methods/phoneConfirmation/processPhoneData';

class SendCodeBtns extends Component {
    constructor(props) {
        super(props);

        this.getConfirmBtnText = this.getConfirmBtnText.bind(this);
        this.handleClick = this.handleClick.bind(this);
    }

    getConfirmBtnText() {
        const {isMobile, isConfirmBtnTextExperiment} = this.props;

        let text = i18n('Frontend.phone_send_code');

        if (isMobile) {
            text = i18n('Phones.phones.confirm-phone');

            if (isConfirmBtnTextExperiment) {
                text = i18n('Frontend.phone_confirm-btn_alternate');
            }
        }
        return text;
    }

    handleClick() {
        this.props.dispatch(processPhoneData());
    }

    render() {
        const {
            isPhoneCallConfirmationAvailable,
            isForcePhoneCallConfirmation,
            canSwitchConfirmationMethod,
            hideNoPhoneLink,
            isValidPhoneForCall,
            isFetching,
            toggleConfirmationMethod,
            isShowSendCodeButton,
            isMobile
        } = this.props;

        const isShowConfirmationMethodToggler =
            canSwitchConfirmationMethod && toggleConfirmationMethod && !hideNoPhoneLink;
        const isShowPhoneCallConfirmationBtn =
            isPhoneCallConfirmationAvailable && isValidPhoneForCall && !isForcePhoneCallConfirmation;
        const isPhoneConfirmationSelectAvailable = isPhoneCallConfirmationAvailable && !isForcePhoneCallConfirmation;
        const isSendCodeBlockShoulBeShowed = (isMobile && isShowSendCodeButton) || !isMobile;
        const isNormalPhoneCall = isPhoneCallConfirmationAvailable && !isForcePhoneCallConfirmation;

        return (
            <div>
                {isShowConfirmationMethodToggler && (
                    <div className='toggle-link link_has-no-phone'>
                        <Link tabIndex='0' onClick={toggleConfirmationMethod} pseudo={true}>
                            {i18n('_AUTH_.no.phone')}
                        </Link>
                    </div>
                )}

                {isSendCodeBlockShoulBeShowed && (
                    <div
                        className={classnames('registration__send-code', {
                            'show-block': isShowSendCodeButton,
                            'phone-confirmation-select-available': isPhoneConfirmationSelectAvailable,
                            'show-call-confirmation-btn': isShowPhoneCallConfirmationBtn
                        })}
                    >
                        {isShowPhoneCallConfirmationBtn && isShowSendCodeButton && (
                            <div className='confirmation_call_prompt-title'>
                                {i18n('Frontend.confirmation_callpromt_title')}
                            </div>
                        )}

                        {isForcePhoneCallConfirmation && (
                            <Button view='pseudo' size='l' width='max' onClick={this.handleClick}>
                                {i18n('Phones.phones.confirm-phone')}
                            </Button>
                        )}

                        {isNormalPhoneCall && (
                            <Button view='action' size='l' width='max' onClick={this.handleClick}>
                                {i18n('Frontend.confirmation_call_phone')}
                            </Button>
                        )}

                        {!isForcePhoneCallConfirmation && (
                            <Button view='pseudo' size='l' width='max' onClick={this.handleClick}>
                                {this.getConfirmBtnText()}
                            </Button>
                        )}

                        {isShowPhoneCallConfirmationBtn && isShowSendCodeButton && (
                            <p className='send_code-description'>
                                {i18n('Frontend.confirmation_call_phone_description')}
                            </p>
                        )}

                        <div className='fetching-block'>
                            <Spin progress={isFetching} size='m' />
                        </div>
                    </div>
                )}
            </div>
        );
    }
}

SendCodeBtns.propTypes = {
    isShowSendCodeButton: PropTypes.bool,
    isConfirmBtnTextExperiment: PropTypes.bool,
    phone: PropTypes.string.isRequired,
    error: PropTypes.object.isRequired,
    isPhoneCallConfirmationAvailable: PropTypes.bool.isRequired,
    isForcePhoneCallConfirmation: PropTypes.bool.isRequired,
    canSwitchConfirmationMethod: PropTypes.bool.isRequired,
    isValidPhoneForCall: PropTypes.bool,
    isFetching: PropTypes.bool,
    hideNoPhoneLink: PropTypes.bool,
    toggleConfirmationMethod: PropTypes.func,
    forcePhoneConfirmation: PropTypes.func,
    sendCode: PropTypes.func,
    dispatch: PropTypes.func.isRequired,
    isMobile: PropTypes.bool
};

export default SendCodeBtns;
