import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import FieldPopup from '@blocks/registration/desktop/errorPopup/error_popup.jsx';
import classnames from 'classnames';

import checkIfInvalid from '@blocks/registration/methods/checkIfInvalid';
import {changeActiveField, setFieldErrorActive, updateValues} from '@blocks/actions/form';
import validateName from '@blocks/registration/methods/validateName';

export default class RegistrationSurnameInput extends PureComponent {
    constructor(props) {
        super(props);

        this.errors = {
            missingvalue: i18n('_AUTH_.lastname_errors_missingvalue'),
            toolong: i18n('_AUTH_.lastname_errors_toolong')
        };

        this.validate = this.validate.bind(this);
        this.checkInvalid = this.checkInvalid.bind(this);
        this.changeFakeSurname = this.changeFakeSurname.bind(this);
        this.checkFieldPopupVisible = this.checkFieldPopupVisible.bind(this);

        this.isLoading = true;
    }

    componentDidMount() {
        this.isLoading = false;

        if (this.props.state === 'need_validation') {
            this.validate();
        }

        this.forceUpdate();
    }

    validate() {
        const {dispatch, value} = this.props;

        dispatch(validateName(value, 'lastname'));
    }

    checkInvalid() {
        const {dispatch} = this.props;

        dispatch(setFieldErrorActive(''));
        dispatch(changeActiveField('lastname'));
        dispatch(checkIfInvalid('lastname'));
    }

    changeFakeSurname(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const {dispatch} = this.props;

        dispatch(updateValues({value, field: name}));
    }

    checkFieldPopupVisible() {
        const {isMobile, activeError, state} = this.props;
        const isNotValid = state === 'not_valid';

        if (isMobile) {
            return isNotValid;
        }
        return isNotValid && activeError === 'lastname';
    }

    render() {
        const {state, value, surnameValue, error, updateUserField} = this.props;
        const field = 'lastname';
        const isNotValid = state === 'not_valid';
        const text = value;
        const isPopupVisible = this.checkFieldPopupVisible();

        return (
            <div
                className={classnames('form__field', {
                    form__field_filled: text || this.isLoading,
                    field__error: isNotValid,
                    field__valid: state === 'valid'
                })}
            >
                <Input
                    id={field}
                    value={text}
                    name={field}
                    onChange={updateUserField}
                    onFocus={this.checkInvalid}
                    onBlur={this.validate}
                    view='one-border'
                    state={isNotValid ? 'error' : ''}
                    filled={!!text || this.isLoading}
                />
                <label htmlFor={field} className='registration__label'>
                    {i18n('_AUTH_.field_lastname')}
                </label>
                {isNotValid && (
                    <FieldPopup fieldName='lastname' visible={isPopupVisible}>
                        <div className='form__popup-error' data-t='lastname-error' role='alert'>
                            <div className='error-message'>{error.text}</div>
                        </div>
                    </FieldPopup>
                )}
                <Input
                    className='g-hidden'
                    value={surnameValue}
                    onChange={this.changeFakeSurname}
                    id='surname'
                    name='surname'
                />
            </div>
        );
    }
}

RegistrationSurnameInput.propTypes = {
    value: PropTypes.string.isRequired,
    surnameValue: PropTypes.string,
    activeError: PropTypes.string,
    state: PropTypes.string.isRequired,
    error: PropTypes.object.isRequired,
    hintActive: PropTypes.bool,
    activeField: PropTypes.string.isRequired,
    updateUserField: PropTypes.func.isRequired,
    isMobile: PropTypes.bool,
    dispatch: PropTypes.func.isRequired
};
