import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import RegistrationNameInput from './name/name_input.jsx';
import RegistrationLoginInput from './login/login_input.jsx';
import RegistrationSurnameInput from './surname/surname_input.jsx';
import {GenderInput} from './gender';
import {BirthdayInput} from './birthday';
import {updateValues, updateErrorsValid, changeActiveField} from '@blocks/actions/form';
import getSuggestedLogins from '../methods/getSuggestedLogins';

export default class UserName extends PureComponent {
    constructor(props) {
        super(props);

        this.updateUserField = this.updateUserField.bind(this);
    }

    updateUserField(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const {
            dispatch,
            activeField,
            values: {login}
        } = this.props;
        const fieldInfo = {
            field: name,
            value
        };

        if (activeField !== name) {
            dispatch(changeActiveField(name));
        }

        dispatch(updateValues(fieldInfo));

        if (name === 'login' && value.trim() !== login.trim()) {
            dispatch(updateErrorsValid(name));
        }

        if (!value) {
            dispatch(getSuggestedLogins());
        }
    }

    render() {
        const {
            activeField,
            values,
            states,
            errors,
            isAutoFocuseDisabled,
            isMobile,
            dispatch,
            registrationType
        } = this.props;
        const isChildishReg = registrationType === 'childish';

        return (
            <div>
                <RegistrationNameInput
                    isAutoFocuseDisabled={isAutoFocuseDisabled}
                    dispatch={dispatch}
                    value={values.firstname}
                    state={states.firstname}
                    activeError={errors.active}
                    error={errors.firstname}
                    activeField={activeField}
                    isMobile={isMobile}
                    updateUserField={this.updateUserField}
                />
                <RegistrationSurnameInput
                    dispatch={dispatch}
                    value={values.lastname}
                    surnameValue={values.surname}
                    state={states.lastname}
                    error={errors.lastname}
                    hintActive={errors.hintActive}
                    activeField={activeField}
                    isMobile={isMobile}
                    updateUserField={this.updateUserField}
                />
                {isChildishReg && (
                    <BirthdayInput
                        value={values.birthday}
                        state={states.birthday}
                        error={errors.birthday.text}
                        isMobile={isMobile}
                        activeField={activeField}
                    />
                )}
                {isChildishReg && <GenderInput value={values.gender} updateUserField={this.updateUserField} />}
                <RegistrationLoginInput updateUserField={this.updateUserField} />
            </div>
        );
    }
}

UserName.propTypes = {
    values: PropTypes.object.isRequired,
    states: PropTypes.object.isRequired,
    errors: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    activeField: PropTypes.string.isRequired,
    registrationType: PropTypes.string,
    isAutoFocuseDisabled: PropTypes.bool,
    isMobile: PropTypes.bool
};
