import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import RegistrationPasswordInput from './password/password_input.jsx';
import RegistrationPasswordConfirm from './password/password_confirm.jsx';
import {updateValues} from '@blocks/actions/form';

export default class UserPassword extends PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            fieldType: 'password',
            activeField: ''
        };
        this.updateField = this.updateField.bind(this);
        this.defineActiveField = this.defineActiveField.bind(this);
        this.toggleFieldType = this.toggleFieldType.bind(this);
    }

    updateField(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const fieldInfo = {
            field: name,
            value
        };

        this.props.dispatch(updateValues(fieldInfo));
    }

    toggleFieldType(event) {
        event.preventDefault();
        this.setState((prevState) => {
            return {
                fieldType: prevState.fieldType === 'password' ? 'text' : 'password'
            };
        });
    }

    defineActiveField(field) {
        this.setState(() => {
            return {
                activeField: field
            };
        });
    }

    render() {
        const {values, states, errors, isLiteReg, isMobile, isAutoFocusEnabled, dispatch} = this.props;
        const loginValue = isLiteReg ? values.email : values.login || '';
        const isPasswordConfirmRenders = !isMobile || (isMobile && isLiteReg);

        return (
            <div>
                <RegistrationPasswordInput
                    value={values.password}
                    loginValue={loginValue}
                    passwordState={states.password}
                    isPasswordErrorActive={errors.active === 'password'}
                    isPasswordFieldActive={this.state.activeField === 'password'}
                    passwordError={errors.password}
                    fieldType={this.state.fieldType}
                    updateField={this.updateField}
                    toggleFieldType={this.toggleFieldType}
                    defineActiveField={this.defineActiveField}
                    isMobile={isMobile}
                    isAutoFocusEnabled={isAutoFocusEnabled}
                    dispatch={dispatch}
                />
                {isPasswordConfirmRenders && (
                    <RegistrationPasswordConfirm
                        value={values.password_confirm}
                        passwordValue={values.password}
                        passwordConfirmState={states.password_confirm}
                        passwordConfirmError={errors.password_confirm}
                        hintActive={errors.hintActive}
                        fieldType={this.state.fieldType}
                        activeField={this.state.activeField}
                        updateField={this.updateField}
                        toggleFieldType={this.toggleFieldType}
                        defineActiveField={this.defineActiveField}
                        dispatch={dispatch}
                    />
                )}
            </div>
        );
    }
}

UserPassword.propTypes = {
    values: PropTypes.object.isRequired,
    states: PropTypes.object.isRequired,
    errors: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    isLiteReg: PropTypes.bool,
    isAutoFocusEnabled: PropTypes.bool,
    isMobile: PropTypes.bool
};
