import api from '../../api';
import {updateFetchingStatus} from '../actions';
import {defineRegistrationFunction} from './defineRegistrationFunction';
import checkCaptcha from './checkCaptcha';

const regMethods = {
    submitRegistration(d) {
        const data = Object.assign({}, d);

        return (dispatch, getState) => {
            const {
                common: {from},
                settings: {origin},
                form: {prefix, captchaRequired, keepUnsubscribedValue},
                registrationType = '',
                experimentsList = {}
            } = getState();
            const regFunction = defineRegistrationFunction(prefix, registrationType);
            const {isPlusPromo, plusPromoCode} = experimentsList;

            if (from) {
                data.from = from;
            }

            if (isPlusPromo && plusPromoCode) {
                data.plus_promo_code = plusPromoCode;
            }

            if (keepUnsubscribedValue) {
                data.keepUnsubscribedValue = true;
            }

            if (origin) {
                data.origin = origin;
            }

            dispatch(updateFetchingStatus(true));

            if (data['human-confirmation'] === 'captcha' || captchaRequired) {
                dispatch(checkCaptcha(data));
                return;
            }

            dispatch(regFunction(data));
        };
    },

    asyncRegistration(data) {
        const {trackId} = data;

        delete data.trackId;

        const params = Object.assign({}, data, {
            track_id: trackId,
            eula_accepted: data.eula_accepted === 'y' ? 'on' : 'off'
        });

        return new Promise((resolve, reject) => {
            api.request('registration-alternative', params)
                .then(resolve)
                .fail((error = {}) => {
                    if (Array.isArray(error.error)) {
                        const errorList = error.error;
                        const errorCode = errorList[0] && errorList[0].code;

                        if (errorCode === 'registrationalreadycompletederror') {
                            // PASSP-17624
                            resolve(error);
                            return;
                        }
                    }

                    reject(error);
                });
        });
    },

    registerNeoPhonish(data) {
        const {trackId} = data;

        data.track_id = trackId;
        delete data.trackId;

        return new Promise((resolve, reject) => {
            api.request('registration-neophonish', data)
                .then(resolve)
                .fail(reject);
        });
    },

    prepareFormData(fieldsStatesObj, validationMethod, isMobile = false, registrationType) {
        const fieldsToRemove = ['hint_question_id', 'phoneCode'];
        const preparedFieldsStates = Object.assign({}, fieldsStatesObj);
        const phoneConfirmed =
            preparedFieldsStates.phoneCodeStatus === 'code_sent' && preparedFieldsStates.phoneCode === 'valid';

        if (registrationType !== 'childish') {
            fieldsToRemove.push('birthday', 'gender');
        }

        if (registrationType === 'lite') {
            fieldsToRemove.push('emailCode', 'emailCodeStatus', 'login');
        }

        if (registrationType !== 'lite') {
            fieldsToRemove.push('email');
        }

        if (phoneConfirmed || validationMethod === 'captcha') {
            fieldsToRemove.push('phoneCodeStatus');
        }

        if (validationMethod === 'phone') {
            fieldsToRemove.push('hint_question_id', 'hint_question_custom', 'hint_question', 'hint_answer', 'captcha');
        }

        if (validationMethod === 'captcha') {
            fieldsToRemove.push('phone');
        }

        if (isMobile) {
            fieldsToRemove.push('password_confirm');
        }

        fieldsToRemove.forEach((field) => {
            delete preparedFieldsStates[field];
        });

        return preparedFieldsStates;
    }
};

export default regMethods;
