import api from '@blocks/api';
import {updateFetchingStatus} from '@blocks/registration/actions';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import updateFieldStatus from './updateFieldStatus';
import {defineRegistrationFunction} from './defineRegistrationFunction';
import {errorsTxt} from '@blocks/registration/errors.js';

export default function checkCaptcha(regData) {
    return (dispatch, getState) => {
        const state = getState();
        const prefix = state.form.prefix;
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf,
            answer: state.form.values.captcha
        };
        const regFunction = defineRegistrationFunction(prefix, state.registrationType);
        const errorTexts = errorsTxt.captcha.errors;
        const errorObj = {
            code: '',
            text: ''
        };

        api.request('checkHuman', data)
            .done((response) => {
                const status = response ? response.status : 'error';
                const dataToSend = state.registrationType === 'lite' ? regData && regData.email : regData;

                if (status === 'ok') {
                    dispatch(regFunction(dataToSend));
                } else if (status === 'error') {
                    errorObj.code = response.errors[0];
                    errorObj.text = errorTexts[response.errors[0]];
                    updateFieldStatus('captcha', 'not_valid')(dispatch, errorObj);
                }
            })
            .fail((error) => {
                errorObj.code = (error.errors && error.errors[0]) || 'captcha.cannot_locate';
                errorObj.text = errorTexts[errorObj.code];
                updateFieldStatus('captcha', 'not_valid')(dispatch, errorObj);
                dispatch(reloadCaptcha());
                dispatch(updateFetchingStatus(false));
            });
    };
}
