import {updateStates, updateErrors} from '@blocks/actions/form';

export default function checkIfFieldEmpty(value, field) {
    const isEmpty =
        (typeof value !== 'boolean' && !value) || value.length === 0 || (typeof value === 'string' && !value.trim());

    return function(dispatch, errorText) {
        if (isEmpty) {
            dispatch(updateStates({field, status: 'not_valid'}));
            dispatch(updateErrors({field, error: errorText, active: true}));
            return true;
        }
        return false;
    };
}
