import {updateErrors, setFieldErrorActive} from '@blocks/actions/form';
import {errorsTxt} from '@blocks/registration/errors.js';
import {errorsTxt as lightErrorsTxt} from '@blocks/registration-lite/errors.js';

export default function checkIfInvalid(field) {
    return (dispatch, getState) => {
        const allErrors = Object.assign({}, errorsTxt, lightErrorsTxt);
        const state = getState();
        const status = state.form.states[field];
        const hasErrorText = state.form.errors[field].code;

        if (status === 'not_valid') {
            if (!hasErrorText) {
                const errorObj = {
                    code: 'missingvalue',
                    text: allErrors[field].errors.missingvalue
                };

                dispatch(updateErrors({field, error: errorObj, active: true}));
            }
            dispatch(setFieldErrorActive(field));
        }
    };
}
