import api from '@blocks/api';
import {setCallConfirmationTimer} from '@blocks/actions/form';
import updateFieldStatus from './updateFieldStatus';
import {errorsTxt} from '@blocks/registration/errors';

export default function checkPhoneConfirmationStatus() {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId, csrf},
            form: {
                states: {phoneCode},
                validation: {callConfirmationTimer, humanConfirmationDone}
            }
        } = getState();
        const requestParams = {
            track_id: trackId,
            csrf_token: csrf
        };
        const errors = errorsTxt.phone.errors;

        if (!callConfirmationTimer) {
            return;
        }

        if (phoneCode === 'valid' && humanConfirmationDone) {
            return;
        }

        const stopTimer = () => {
            const timer = getState().form.validation.callConfirmationTimer;

            if (!timer) {
                return false;
            }

            clearTimeout(timer);

            return true;
        };

        api.request('confirm-phone-check-status', requestParams)
            .then(stopTimer)
            .fail((error) => {
                const errorCode =
                    Array.isArray(error.errors) && error.errors.length ? error.errors[0] : 'call_confirm.failed';
                const errorText = errors[errorCode] || errors['call_confirm.failed'];

                const isCallConfirmInProgress =
                    ['call_confirm.in_progress', 'call_confirm.finished'].indexOf(errorCode) > -1;

                const shouldSkipError =
                    ['call_confirm.not_ready', 'call_confirm.started'].indexOf(errorCode) > -1 ||
                    isCallConfirmInProgress;

                if (!stopTimer()) {
                    return;
                }

                if (!shouldSkipError) {
                    updateFieldStatus('phoneCode', 'not_valid')(dispatch, {code: errorCode, text: errorText});
                    dispatch(setCallConfirmationTimer(null));
                    return;
                }

                if (isCallConfirmInProgress) {
                    dispatch(setCallConfirmationTimer(null));
                    return;
                }

                const timer = setTimeout(() => {
                    dispatch(checkPhoneConfirmationStatus());
                }, 1000);

                dispatch(setCallConfirmationTimer(timer));
            });
    };
}
