import {setFieldErrorActive} from '@blocks/actions/form';
import regMethods from './basicRegistrationMethods';

export default function findFieldsWithErrors() {
    return (dispatch, getState) => {
        const state = getState();

        if (state.form.errors.active) {
            return;
        }

        const {settings, form} = state;
        const uatraits = settings.uatraits || settings.ua || {};
        const isMobile = uatraits.isMobile && !uatraits.isTablet;

        const {states, validation} = form;
        const method = validation.method;
        const validatedStates = regMethods.prepareFormData(states, method, isMobile);

        for (const fieldName in validatedStates) {
            if (validatedStates[fieldName] === 'not_valid') {
                dispatch(setFieldErrorActive(fieldName));
                return;
            }
        }
    };
}
