import api from '@blocks/api';
import {getUserQuestionsList, updateQuestionValues, updateQuestionStates} from '@blocks/actions/form';

export default function getQuestions() {
    return (dispatch, getState) => {
        const state = getState();
        const trackId = state.common.track_id;

        api.request('getQuestions', {track_id: trackId}).then((response) => {
            if (response && response.questions && response.questions.length) {
                const questionList = transformQuestions(response.questions).slice(1);
                const initialQuestionData = {
                    hint_question_id: questionList[0].val,
                    hint_question: questionList[0].text
                };

                dispatch(getUserQuestionsList(questionList));
                dispatch(updateQuestionValues(initialQuestionData));
                dispatch(updateQuestionStates({status: 'valid'}));
            }
        });
    };
}

function transformQuestions(questions) {
    return questions.map(function(question, index) {
        return {
            id: `q${index}`,
            val: question.id,
            text: question.value
        };
    });
}
