import api from '../../api';
import {updateSuggestedLogins} from '../actions';

export default function getSuggestedLogins() {
    return (dispatch, getState) => {
        const state = getState();
        const valuesFromState = state.form.values;
        const errorsFromState = state.form.errors;
        const data = {
            track_id: state.common.track_id,
            login: valuesFromState.login || '',
            firstname: valuesFromState.firstname || '',
            lastname: valuesFromState.lastname || ''
        };

        if (!data.firstname.trim() || !data.lastname.trim()) {
            dispatch(updateSuggestedLogins({logins: [], showAll: false, isFetching: false}));
            return;
        }

        dispatch(updateSuggestedLogins({logins: [], showAll: false, isFetching: true}));

        api.request('suggestV2', data)
            .then((response) => {
                let logins = response.logins;

                if (valuesFromState.login && errorsFromState.login.code === 'login.not_available') {
                    logins = logins.filter((login) => login !== valuesFromState.login);
                }

                dispatch(updateSuggestedLogins({logins, showAll: false, isFetching: false}));
            })
            .fail(() => {
                dispatch(updateSuggestedLogins({logins: [], showAll: false, isFetching: false}));
            });
    };
}
