import {errorsTxt} from '@blocks/registration-lite/errors';
import scrollToError from './scrollToError';
import metrics from '@blocks/metrics';
import {updateRegistrationErrors} from '@blocks/registration/actions';
import {updateErrorStates, updateGroupErrors} from '@blocks/actions/form';

export default function handleValidationError(dispatch, emptyFields, errorFields, isMobile) {
    const errorDOMEl = document.querySelector(`#${Object.keys(emptyFields)[0]}`);

    if (!errorDOMEl) {
        dispatch(
            updateRegistrationErrors({
                status: 'error',
                code: 'global',
                text: errorsTxt.global.errors.smthWrong,
                descriptionText: ''
            })
        );
        return;
    }

    dispatch(updateErrorStates(emptyFields));
    dispatch(updateGroupErrors(Object.assign({}, {active: Object.keys(errorFields)[0]}, errorFields)));
    scrollToError(errorDOMEl, undefined, isMobile ? 100 : 0);

    metrics.send(['Форма', 'Показ ошибок']);
    metrics.goal('form_invalid');
}
