import sendPhoneCode from './sendPhoneCode';
import forcePhoneConfirmation from './forcePhoneConfirmation';

export default function processPhoneData() {
    return (dispatch, getState) => {
        const {form} = getState();
        const {isPhoneCallConfirmationAvailable, isForcePhoneCallConfirmation} = form;

        if (isForcePhoneCallConfirmation) {
            dispatch(forcePhoneConfirmation());
        }

        if (isPhoneCallConfirmationAvailable && !isForcePhoneCallConfirmation) {
            dispatch(sendPhoneCode(false, true));
        }

        if (!isForcePhoneCallConfirmation) {
            dispatch(sendPhoneCode(false, false));
        }
    };
}
