import {
    REGISTRATION_GOAL_PREFIX,
    togglePhoneConfirmationPopup,
    updatePhoneCodeHintStatus,
    updatePhoneCodeSendAgain
} from '@blocks/registration/actions';
import {setCallConfirmationTimer, updateErrors} from '@blocks/actions/form';
import submitPhoneConfirmationCode from '@blocks/registration/methods/submitPhoneConfirmationCode';
import validatePassword from '@blocks/registration/methods/validatePassword';
import validatePhoneNumber from '@blocks/registration/methods/validatePhoneNumber';

export default function sendPhoneCode(sendAgain = false, isCallConfirmation = false) {
    return (dispatch, getState) => {
        const {
            settings: {uatraits},
            form,
            phoneConfirmation: {isCodeSentAgain}
        } = getState();
        const {validation, states, values, prefix, isPhoneCallConfirmationAvailable} = form;
        const password = values.password;
        const isMobile = uatraits.isMobile && !uatraits.isTablet;
        const codeStatus = states.phoneCodeStatus;
        const phone = values.phone;
        const {phoneConfirmationType, callConfirmationTimer} = validation;
        const regPrefix = prefix || REGISTRATION_GOAL_PREFIX;
        const isSendCodeShouldBeSkipped =
            isMobile && !sendAgain && codeStatus === 'code_sent' && phoneConfirmationType !== 'call';
        const isNeedPhoneValidation = isPhoneCallConfirmationAvailable && validation.phoneConfirmationType === 'call';

        dispatch(showCodeHint(false));

        if (isMobile) {
            dispatch(togglePhoneConfirmationPopup(true));
        }

        if (phoneConfirmationType === 'call') {
            if (callConfirmationTimer) {
                clearTimeout(callConfirmationTimer);
            }

            dispatch(setCallConfirmationTimer(null));
        }

        if (sendAgain && isCallConfirmation) {
            dispatch(updateErrors({field: 'phone', error: '', active: false}));
            dispatch(updateErrors({field: 'phoneCode', error: '', active: false}));
        }

        if (!isSendCodeShouldBeSkipped) {
            if (typeof password !== 'undefined' && regPrefix.indexOf('complete_lite') !== 0) {
                dispatch(validatePassword(password, 'phone', isCallConfirmation));
            } else {
                dispatch(submitPhoneConfirmationCode(phone, isCallConfirmation, sendAgain));
            }

            if (sendAgain && codeStatus === 'code_sent') {
                if (isNeedPhoneValidation) {
                    dispatch(validatePhoneNumber(phone));
                }
                dispatch(updatePhoneCodeSendAgain(!isCodeSentAgain));
            }
        }
    };
}

function showCodeHint(showHint) {
    return (dispatch, getState) => {
        const {
            form: {isPhoneCallConfirmationAvailable, validation, values}
        } = getState();
        const phone = values.phone;
        const isNeedPhoneValidation = isPhoneCallConfirmationAvailable && validation.phoneConfirmationType === 'call';

        if (isNeedPhoneValidation) {
            dispatch(validatePhoneNumber(phone));
        }

        dispatch(updatePhoneCodeHintStatus(showHint));
    };
}
