export default function returnFormData(sendEulaMoneyValue) {
    return (dispatch, getState) => {
        const state = getState();
        const {form, settings} = state;
        const {values, validation} = form;
        const {tmxSession} = settings;
        const method = validation.method;
        const formData = Object.assign({}, values);
        const CUSTOM_QUESTION_ID = '99';

        if (method === 'captcha' && values.hint_question_id === CUSTOM_QUESTION_ID) {
            formData.hint_question = values.hint_question_custom;
        }
        formData['human-confirmation'] = method;

        if (sendEulaMoneyValue) {
            formData.money_eula_accepted = 'on';
            formData.tmx_session = tmxSession;
        }
        return formData;
    };
}
