export default function scrollToError(destination, duration = 200, add = 0) {
    const start = window.pageYOffset;
    // eslint-disable-next-line compat/compat
    const startTime = 'now' in window.performance ? performance.now() : new Date().getTime();
    const documentHeight = Math.max(
        document.body.scrollHeight,
        document.body.offsetHeight,
        document.documentElement.clientHeight,
        document.documentElement.scrollHeight,
        document.documentElement.offsetHeight
    );
    const windowHeight =
        window.innerHeight ||
        document.documentElement.clientHeight ||
        document.getElementsByTagName('body')[0].clientHeight;

    let destinationOffset;

    let parent = destination.parentNode;

    for (let i = 0; i <= 5; i++) {
        if (parent.parentNode.tagName === 'FORM' || parent.parentNode.className.indexOf('scroll-stop') !== -1) {
            destinationOffset = parent.offsetTop + add;
            break;
        } else if (i === 5) {
            destination.focus();
            return;
        }

        parent = parent.parentNode;
    }

    const destinationOffsetToScroll = Math.round(
        documentHeight - destinationOffset < windowHeight ? documentHeight - windowHeight : destinationOffset
    );

    if ('requestAnimationFrame' in window === false) {
        window.scroll(0, destinationOffsetToScroll);
        return;
    }

    function scroll() {
        // eslint-disable-next-line compat/compat
        const now = 'now' in window.performance ? performance.now() : new Date().getTime();
        const time = Math.min(1, (now - startTime) / duration);

        window.scroll(0, Math.ceil(time * (destinationOffsetToScroll - start) + start));

        if (window.pageYOffset === destinationOffsetToScroll || time >= 1) {
            return;
        }

        requestAnimationFrame(scroll);
    }
    scroll();
}
