import {
    REGISTRATION_GOAL_PREFIX,
    SEND_SMS_METRIC_PARAM,
    SEND_SMS_AGAIN_METRIC_PARAM,
    MAKE_CALL_METRIC_PARAM,
    MAKE_CALL_AGAIN_METRIC_PARAM,
    MAGIC_CALL_CONFIRMATION_METRIC_PARAM,
    DICTATION_CALL_CONFIRMATION_METRIC_PARAM,
    SMS_CONFIRMATION_METRIC_PARAM,
    DISCARD_CALL_CONFIRMATION_METRIC_PARAM
} from '../actions';

import metrics from '../../metrics';

const METRIC_PARAMS = {
    sms: [SMS_CONFIRMATION_METRIC_PARAM, SEND_SMS_METRIC_PARAM],
    sms_again: [SMS_CONFIRMATION_METRIC_PARAM, SEND_SMS_AGAIN_METRIC_PARAM],
    sms_for_magic: [MAGIC_CALL_CONFIRMATION_METRIC_PARAM, SEND_SMS_METRIC_PARAM],
    sms_for_magic_again: [MAGIC_CALL_CONFIRMATION_METRIC_PARAM, SEND_SMS_AGAIN_METRIC_PARAM],
    sms_for_dictation: [DICTATION_CALL_CONFIRMATION_METRIC_PARAM, SEND_SMS_METRIC_PARAM],
    sms_for_dictation_again: [DICTATION_CALL_CONFIRMATION_METRIC_PARAM, SEND_SMS_AGAIN_METRIC_PARAM],
    sms_for_discard_call: [DISCARD_CALL_CONFIRMATION_METRIC_PARAM, SEND_SMS_METRIC_PARAM],
    sms_for_discard_call_again: [DISCARD_CALL_CONFIRMATION_METRIC_PARAM, SEND_SMS_AGAIN_METRIC_PARAM],
    discard_call: [DISCARD_CALL_CONFIRMATION_METRIC_PARAM, MAKE_CALL_METRIC_PARAM],
    discard_call_again: [DISCARD_CALL_CONFIRMATION_METRIC_PARAM, MAKE_CALL_AGAIN_METRIC_PARAM],
    call_for_dictation: [DICTATION_CALL_CONFIRMATION_METRIC_PARAM, MAKE_CALL_METRIC_PARAM],
    call_for_dictation_again: [DICTATION_CALL_CONFIRMATION_METRIC_PARAM, MAKE_CALL_AGAIN_METRIC_PARAM]
};

export default function sendMetricsForSendingConfirmationCode(isSendConfirmationAgain, isCallConfirmation) {
    return (dispatch, getState) => {
        const {form} = getState();
        const {
            isPhoneCallConfirmationAvailable,
            isForcePhoneCallConfirmation,
            isDiscardCallConfirmation,
            prefix
        } = form;
        const finalPrefix = prefix || REGISTRATION_GOAL_PREFIX;

        let metricParams = [];

        let metricGoalTarget = `${finalPrefix}_phoneconfirm_codesent`;

        let confirmationType = 'sms';

        if (isCallConfirmation) {
            confirmationType = isDiscardCallConfirmation ? 'discard_call' : 'call_for_dictation';
        } else if (isPhoneCallConfirmationAvailable) {
            if (isDiscardCallConfirmation) {
                confirmationType += '_for_discard_call';
            } else {
                confirmationType += '_for_dictation';
            }
        }

        if (isSendConfirmationAgain) {
            confirmationType += '_again';
        }

        metricGoalTarget += `_${confirmationType}`;

        if (isForcePhoneCallConfirmation) {
            metricGoalTarget += '_forced';
        }

        metricParams = METRIC_PARAMS[confirmationType] || METRIC_PARAMS.sms;

        metrics.send(metricParams);
        metrics.goal(metricGoalTarget);
    };
}
