import {
    REGISTRATION_GOAL_PREFIX,
    MAGIC_CALL_CONFIRMATION_METRIC_PARAM,
    DICTATION_CALL_CONFIRMATION_METRIC_PARAM,
    DISCARD_CALL_CONFIRMATION_METRIC_PARAM
} from '../actions';

import metrics from '../../metrics';

export default function sendMetricsForShowCallConfirmationBtns() {
    return (dispatch, getState) => {
        const {form} = getState();
        const {
            isPhoneCallConfirmationAvailable,
            isForcePhoneCallConfirmation,
            isDiscardCallConfirmation,
            prefix
        } = form;
        const finalPrefix = prefix || REGISTRATION_GOAL_PREFIX;

        const metricParams = ['Показ двух кнопок Позвонить + Прислать код'];

        let metricGoalTarget = `${finalPrefix}_`;

        if (isDiscardCallConfirmation) {
            metricParams.unshift(DISCARD_CALL_CONFIRMATION_METRIC_PARAM);
            metricGoalTarget += 'show_call_confirm_btn_with_discard_call';
        } else if (isPhoneCallConfirmationAvailable) {
            metricParams.unshift(DICTATION_CALL_CONFIRMATION_METRIC_PARAM);
            metricGoalTarget += 'show_call_confirm_btn';
        } else {
            metricParams.unshift(MAGIC_CALL_CONFIRMATION_METRIC_PARAM);
            metricGoalTarget += 'show_call_confirm_btn_with_magic_call';
        }

        if (isForcePhoneCallConfirmation) {
            metricGoalTarget += '_forced';
        }

        metrics.send(metricParams);
        metrics.goal(metricGoalTarget);
    };
}
