import {updateStates, updateErrors} from '@blocks/actions/form';

export default function updateFieldStatus(field, status) {
    if (status === 'valid') {
        return function(dispatch) {
            dispatch(updateStates({field, status}));
            dispatch(updateErrors({field, error: {code: '', text: ''}, active: false}));
        };
    }
    return function(dispatch, error, errorDescription = '', active = true) {
        dispatch(updateStates({field, status}));
        dispatch(updateErrors({field, error, errorDescription, active}));
    };
}
