import api from '../../api';
import updateFieldStatus from './updateFieldStatus';
import findFieldsWithErrors from './findFieldsWithErrors';
import {errorsTxt} from '../errors.js';

export default function validateConnectLogin(login) {
    return (dispatch, getState) => {
        const {
            form: {
                values: {domain},
                errors: {login: loginError}
            },
            common: {track_id}
        } = getState();

        if (!login) {
            if (loginError.code === 'login.no_domain') {
                updateFieldStatus('login', '')(dispatch, getState);
            }

            return;
        }

        api.request('orgadmin', {track_id, login: `${login.trim()}@${domain}.yaconnect.com`})
            .then((response) => {
                if (response.hasOwnProperty('validation_errors')) {
                    const code = `login.${response.validation_errors[0].code}`;

                    updateFieldStatus('login', 'not_valid')(dispatch, {
                        code,
                        text: errorsTxt.login.errors[code] || errorsTxt.login.errors['login.invalid'],
                        descriptionText:
                            (code === 'login.long'
                                ? errorsTxt.login.descriptions['connect.login.long']
                                : errorsTxt.login.descriptions[code]) || ''
                    });
                    return;
                }

                updateFieldStatus('login', 'valid')(dispatch, getState);
                dispatch(findFieldsWithErrors());
            })
            .fail((e) => {
                const code = (e.errors && e.errors[0]) || '';

                updateFieldStatus('login', 'not_valid')(dispatch, {
                    code,
                    text: errorsTxt.login.errors[code] || errorsTxt.login.errors['login.invalid'],
                    descriptionText: errorsTxt.login.descriptions[code] || ''
                });
            });
    };
}
