import api from '@blocks/api';
import {updateErrorsValid} from '@blocks/actions/form';
import updateFieldStatus from './updateFieldStatus';
import checkIfFieldEmpty from './checkIfFieldEmpty';
import findFieldsWithErrors from './findFieldsWithErrors';
import validateConnectLogin from './validateConnectLogin';
import {errorsTxt} from '../errors.js';

export default function validateConnectDomain(domain) {
    return (dispatch, getState) => {
        const {
            form: {
                values: {login}
            },
            common: {track_id}
        } = getState();
        const missingValueError = {
            code: 'missingvalue',
            text: errorsTxt.domain.errors.missingvalue
        };

        if (domain.indexOf('.') >= 0) {
            const code = 'domain.containssubdomain';

            updateFieldStatus('domain', 'not_valid')(dispatch, {
                code,
                text: errorsTxt.domain.errors[code],
                descriptionText: errorsTxt.domain.descriptions[code]
            });
            return;
        } else if (checkIfFieldEmpty(domain, 'domain')(dispatch, missingValueError)) {
            return;
        }
        api.request('orgdomain', {track_id, domain})
            .then(() => {
                const {
                    form: {
                        errors: {active},
                        values: {login: nextLogin}
                    }
                } = getState();

                if (login === nextLogin) {
                    dispatch(validateConnectLogin(login));
                }

                updateFieldStatus('domain', 'valid')(dispatch, getState);
                dispatch(findFieldsWithErrors());
                if (active === 'domain') {
                    dispatch(updateErrorsValid('domain'));
                }
            })
            .fail((e) => {
                const code = (e.errors && e.errors[0]) || '';

                updateFieldStatus('domain', 'not_valid')(dispatch, {
                    code,
                    text: errorsTxt.domain.errors[code] || errorsTxt.domain.errors['domain.invalid'],
                    descriptionText: errorsTxt.domain.descriptions[code] || ''
                });
            });
    };
}
