import api from '../../api';
import updateFieldStatus from './updateFieldStatus';
import findFieldsWithErrors from './findFieldsWithErrors';
import checkIfFieldEmpty from './checkIfFieldEmpty';
import {errorsTxt} from '../errors.js';

export default function validateHint(data, validatedData) {
    return (dispatch, getState) => {
        const track = getState().common.track_id;

        let fieldName = Object.keys(data)[0];
        const requestData = Object.assign({}, {track_id: track}, data);
        const errors =
            validatedData === 'question' ? errorsTxt.hint.hintQuestionErrors : errorsTxt.hint.hintAnswerErrors;

        if (
            checkIfFieldEmpty(data[fieldName], fieldName)(dispatch, {code: 'missingvalue', text: errors.missingvalue})
        ) {
            return;
        }

        api.request('answer', requestData)
            .then((response) => {
                const notValid = response.validation_errors;
                const status = notValid ? 'not_valid' : 'valid';
                const errorObj = {
                    code: notValid ? notValid[0].code : '',
                    text: notValid ? errors[notValid[0].code] : ''
                };

                if ((notValid && notValid[0].field === 'hint_question') || response.hint_question) {
                    fieldName = 'hint_question_custom';
                }
                if (status === 'valid') {
                    updateFieldStatus(fieldName, status)(dispatch, getState);
                    dispatch(findFieldsWithErrors());
                } else {
                    updateFieldStatus(fieldName, status)(dispatch, errorObj);
                }
            })
            .fail(() => {
                const errorObj = {
                    code: 'global',
                    text: errorsTxt.global && errorsTxt.global.errors && errorsTxt.global.errors.global
                };

                updateFieldStatus(fieldName, 'not_valid')(dispatch, errorObj);
            });
    };
}
