import api from '../../api';
import {setSuggestionFetching} from '../actions';
import updateFieldStatus from './updateFieldStatus';
import findFieldsWithErrors from './findFieldsWithErrors';
import getSuggestedLogins from './getSuggestedLogins';
import validatePassword from './validatePassword';
import metrics from '../../metrics';
import {errorsTxt} from '../errors.js';

export default function validateLogin(login) {
    return (dispatch, getState) => {
        const state = getState();
        const trackId = state.common.track_id;
        const errors = errorsTxt.login.errors;
        const errorDescriptions = errorsTxt.login.descriptions;
        const password = state.form.values.password;
        const firstname = state.form.values.firstname || '';
        const lastname = state.form.values.lastname || '';

        dispatch(setSuggestionFetching(true));

        api.request('login', {track_id: trackId, login}).then((response) => {
            dispatch(setSuggestionFetching(false));

            if (response !== undefined) {
                const errorCode = Array.isArray(response) ? response : null;
                const errorObj = {
                    code: '',
                    text: '',
                    descriptionText: ''
                };

                if (errorCode) {
                    errorObj.code = errorCode[0];
                    errorObj.text = errorCode.map((code) => errors[code])[0];
                    errorObj.descriptionText = errorCode.map((code) => errorDescriptions[code])[0];

                    if (!firstname.trim() || !lastname.trim()) {
                        errorObj.descriptionText = '';
                    }
                }

                if (response.status === 'ok') {
                    updateFieldStatus('login', 'valid')(dispatch, getState);
                    dispatch(findFieldsWithErrors());
                    metrics.send(['Форма', 'Успешное заполнение поля "логин"']);
                } else {
                    updateFieldStatus('login', 'not_valid')(dispatch, errorObj);
                    if (login.length > 0 || !state.logins.loginsList.length) {
                        dispatch(getSuggestedLogins());
                    }
                }
            }
        });

        if (password && state.form.type !== 'complete_lite') {
            dispatch(validatePassword(password, 'login'));
        }
    };
}
