import api from '@blocks/api';
import findFieldsWithErrors from './findFieldsWithErrors';
import metrics from '@blocks/metrics';
import {errorsTxt} from '@blocks/registration/errors';
import {updateFetchingStatus} from '@blocks/registration/actions';
import {changeActiveField, updateErrors, updateStates} from '@blocks/actions/form';

export default function validateName(name = '', field = 'firstname') {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId, csrf}
        } = getState();
        const params = {
            track_id: trackId,
            csrf_token: csrf,
            [field]: name
        };
        const nameErrorsTexts = errorsTxt[field].errors;

        if (!name.trim()) {
            dispatch(updateStates({field, status: 'not_valid'}));
            dispatch(
                updateErrors({
                    field,
                    error: {
                        code: 'missingvalue',
                        text: nameErrorsTexts.missingvalue
                    },
                    active: true
                })
            );
            return;
        }
        dispatch(updateFetchingStatus(true));
        dispatch(changeActiveField(''));
        dispatch(
            updateErrors({
                field,
                error: {
                    code: '',
                    text: ''
                },
                active: false
            })
        );

        api.request(`validate-${field}`, params)
            .then((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(
                        updateStates({
                            field,
                            status: 'valid'
                        })
                    );
                    dispatch(findFieldsWithErrors());
                }
                metrics.send(['Форма', `Успешное заполнение поля "${field}"`]);
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.errors) && error.errors[0];

                dispatch(updateStates({field, status: 'not_valid'}));
                dispatch(
                    updateErrors({
                        field,
                        error: {
                            code: errorCode,
                            text: nameErrorsTexts[errorCode]
                        },
                        active: true
                    })
                );
            })
            .always(() => {
                dispatch(updateFetchingStatus(false));
            });
    };
}
