import api from '../../api';
import validatePasswordConfirm from './validatePasswordConfirm';
import updateFieldStatus from './updateFieldStatus';
import checkIfFieldEmpty from './checkIfFieldEmpty';
import findFieldsWithErrors from './findFieldsWithErrors';
import submitPhoneConfirmationCode from './submitPhoneConfirmationCode';
import {errorsTxt} from '../errors.js';

export default function validatePassword(password, activeField, isCallConfirmation = false) {
    return (dispatch, getState) => {
        const state = getState();
        const isLiteReg = state.registrationType && state.registrationType === 'lite';
        const trackId = state.common.track_id;
        const {login, email, password_confirm: passwordConfirm, phone} = state.form.values;
        const errors = errorsTxt.password.errors;
        const errorDescriptions = errorsTxt.password.descriptions;
        const isPhoneError = state.form.errors.phone && state.form.errors.phone.code === 'likephonenumber';
        const loginToPass = isLiteReg ? email : login;

        if (passwordConfirm) {
            dispatch(validatePasswordConfirm(passwordConfirm, password));
        }

        if (checkIfFieldEmpty(password, 'password')(dispatch, {code: 'missingvalue', text: errors.missingvalue})) {
            return;
        }

        if (isPhoneError) {
            updateFieldStatus('phone', 'valid')(dispatch, getState);
        }

        api.request('password', {track_id: trackId, password, login: loginToPass, phone_number: phone}).then(
            (response) => {
                const validationError = (response && response.validation_errors) || response.validation_warnings;

                if (validationError && Array.isArray(validationError)) {
                    const errorTypeIsWarning = response.validation_warnings;
                    const errorObj = {
                        code: validationError[0].code,
                        text: errors[validationError[0].code],
                        errorDescription: errorDescriptions[validationError[0].code]
                    };

                    if (errorTypeIsWarning) {
                        errorObj.warning = true;
                    }

                    if (errorTypeIsWarning && errorObj.code === 'weak') {
                        if (activeField === 'phone') {
                            return dispatch(submitPhoneConfirmationCode(phone, isCallConfirmation));
                        }

                        errorObj.code = 'warning.weak';
                        errorObj.text = errors['warning.weak'];
                        errorObj.errorDescription = errorDescriptions['warning.weak'];
                    }

                    if (
                        validationError[0].message &&
                        validationError[0].message.indexOf('10 symbols') !== -1 &&
                        validationError[0].code === 'tooshort'
                    ) {
                        errorObj.text = errors['strong_pwd.tooshort'];
                    }

                    if (activeField === 'login') {
                        updateFieldStatus('password', 'not_valid')(dispatch, errorObj, '', false);
                    } else {
                        updateFieldStatus('password', 'not_valid')(dispatch, errorObj);
                    }

                    if (activeField === 'phone' && errorObj.code === 'likephonenumber') {
                        updateFieldStatus('phone', 'not_valid')(dispatch, errorObj);
                    }
                } else {
                    if (activeField === 'phone') {
                        return dispatch(submitPhoneConfirmationCode(phone, isCallConfirmation));
                    }

                    updateFieldStatus('password', 'valid')(dispatch, getState);
                    dispatch(findFieldsWithErrors());
                }
            }
        );
    };
}
