import updateFieldStatus from './updateFieldStatus';
import checkIfFieldEmpty from './checkIfFieldEmpty';
import findFieldsWithErrors from './findFieldsWithErrors';
import {errorsTxt} from '../errors.js';

export default function validatePasswordConfirm(confirm, password) {
    return (dispatch, getState) => {
        const errors = errorsTxt.password_confirm.errors;
        const notEqual = confirm !== password;
        const status = notEqual ? 'not_valid' : 'valid';

        if (
            checkIfFieldEmpty(confirm, 'password_confirm')(dispatch, {code: 'missingvalue', text: errors.missingvalue})
        ) {
            return;
        }
        if (status === 'valid') {
            updateFieldStatus('password_confirm', 'valid')(dispatch, getState);
            dispatch(findFieldsWithErrors());
        } else {
            updateFieldStatus('password_confirm', 'not_valid')(dispatch, {code: 'notequal', text: errors.notequal});
        }
    };
}
