import api from '@blocks/api';
import {validatePhoneForCall} from '@blocks/actions/form';

export default function validatePhoneNumber(phoneNumber) {
    return (dispatch, getState) => {
        const {
            settings: {country},
            common: {track_id: trackId, csrf}
        } = getState();
        const requestParams = {
            country,
            phone_number: phoneNumber,
            validate_for_call: true,
            check_speech: true,
            track_id: trackId,
            csrf_token: csrf
        };

        api.request('validate-phone', requestParams)
            .done((response) => {
                const isValid = Boolean(response.valid_for_call) && response.status === 'ok';

                dispatch(validatePhoneForCall(isValid));
            })
            .fail(() => {
                dispatch(validatePhoneForCall(false));
            });
    };
}
