import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import Footer from '@components/Footer/Footer.jsx';
import SpinnerComponent from '@blocks/registration/spinner/spinner.jsx';

import './MobileFooter.styl';

const MobileFooter = ({isMobile, isFetching}) => {
    if (isMobile) {
        return (
            <div className='footer_mobile'>
                <Footer />
                <div className={classnames('fade', {'fade_is-visible': isFetching})}>
                    <SpinnerComponent />
                </div>
            </div>
        );
    }
    return null;
};

MobileFooter.propTypes = {
    isMobile: PropTypes.bool,
    isFetching: PropTypes.bool
};

export default MobileFooter;
