import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import ServicesIconsScroll from './services_icons_scroll.jsx';
import Logo from '@blocks/registration/customizations/Logo';

const SERVICES_LIST = [
    'afisha',
    'avia',
    'browser',
    'direct',
    'key',
    'launcher',
    'maps',
    'metrika',
    'news',
    'pogoda',
    'rabota',
    'radio',
    'realty',
    'teleprogramma',
    'toloka'
];

export class RegistrationHeader extends Component {
    static mapStateToProps(state) {
        const {
            settings: {tld, language, staticPath, uatraits}
        } = state;

        return {
            uatraits,
            tld,
            language,
            staticPath
        };
    }

    static defineServicesIconsByTLD(tld, page) {
        const isCom = ['com', 'com.tr'].includes(tld);
        const isUa = ['ua', 'kz', 'by'].includes(tld);
        const servicesList = {
            isCom: ['maps', 'browser', 'translate', 'mail', 'disk'],
            isUa: ['maps', 'mail', 'disk', 'market', 'music'],
            isRu: ['mail', 'disk', 'market', 'music']
        };

        if (page === 'complete') {
            servicesList.isRu = ['toloka', 'mail', 'disk', 'direct'];
        }

        if (isCom) {
            return servicesList.isCom;
        }

        if (isUa) {
            return servicesList.isUa;
        }

        return servicesList.isRu.concat(SERVICES_LIST);
    }

    render() {
        const {uatraits, staticPath, tld, skipPromo} = this.props;
        const isMobile = Boolean(uatraits.isTouch && !uatraits.isTablet);
        const servicesList = RegistrationHeader.defineServicesIconsByTLD(tld, this.props.page);

        if (isMobile && !skipPromo) {
            return (
                <div className='registration__header_mobile registration__form_mobile'>
                    <Logo origin='default' staticPath={staticPath} />
                    <div className='step__item-content scroll-stop'>
                        <ServicesIconsScroll services={servicesList} staticPath={staticPath} ua={uatraits} />
                        <h1 className='step__title'>{i18n('Frontend.registration_main-title_id')}</h1>
                    </div>
                </div>
            );
        }
        return null;
    }
}

export default connect(RegistrationHeader.mapStateToProps)(RegistrationHeader);

RegistrationHeader.propTypes = {
    uatraits: PropTypes.object.isRequired,
    tld: PropTypes.string.isRequired,
    language: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired,
    titleText: PropTypes.string,
    page: PropTypes.string,
    skipPromo: PropTypes.bool
};
