import {updateValues, updateStates} from '@blocks/actions/form';
import {clearSuggestedLogins} from '@blocks/registration/actions';
import validateLogin from '@blocks/registration/methods/validateLogin';
import getSuggestedLogins from '@blocks/registration/methods/getSuggestedLogins';
import checkIfInvalid from '@blocks/registration/methods/checkIfInvalid';

/* eslint-disable no-invalid-this */

export function clearAll() {
    if (this.loginFieldFocusTimeout) {
        clearTimeout(this.loginFieldFocusTimeout);
    }

    if (this.loginFieldFocusOutTimeout) {
        clearTimeout(this.loginFieldFocusOutTimeout);
    }

    this.handleValidation.cancel();
}

export function updateUserField(value, field) {
    const fieldInfo = {
        field: field.name,
        value
    };

    this.props.dispatch(updateValues(fieldInfo));
}

export function handleInput(event) {
    const {target = {}} = event;
    const {value} = target;

    this.props.dispatch(clearSuggestedLogins());
    this.props.dispatch(updateStates({field: 'login', status: 'not_valid'}));
    updateUserField.call(this, value, {name: 'login'});
    this.handleValidation(value);
}

export function handleValidation(value) {
    this.props.dispatch(validateLogin(value));
}

export function handleFocus() {
    const {firstname, lastname, fieldState, dispatch} = this.props;
    const fieldIsValid = fieldState === 'valid';

    this.setState({
        isActive: true,
        isValid: fieldIsValid
    });

    dispatch(checkIfInvalid('login'));

    if (firstname && lastname) {
        dispatch(getSuggestedLogins());
    }
}

export function handleFocusout() {
    const self = this;
    const fieldIsValid = this.props.fieldState === 'valid';
    const newStateObj = {
        isActive: false,
        isValid: fieldIsValid
    };

    this.loginFieldFocusOutTimeout = setTimeout(function() {
        self.setState(newStateObj);
    }, this.timeOut);
}
