import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

class LoginSuggestOption extends Component {
    constructor(props) {
        super(props);

        this.state = {isShowed: false};

        this.showOptionTimeout = null;
    }

    componentDidMount() {
        const self = this;

        if (this.showOptionTimeout) {
            clearTimeout(this.showOptionTimeout);
        }

        this.showOptionTimeout = setTimeout(() => {
            self.setState(() => ({isShowed: true}));
        }, 100);
    }

    componentWillUnmount() {
        if (this.showOptionTimeout) {
            clearTimeout(this.showOptionTimeout);
        }
    }

    render() {
        const {login, setSelectedLogin} = this.props;
        const {isShowed} = this.state;

        return (
            <div className={classnames('registration__pseudo-link', {showed: isShowed})}>
                <label htmlFor={login}>
                    <input type='radio' onChange={setSelectedLogin} id={login} />
                    {login}
                </label>
            </div>
        );
    }
}

LoginSuggestOption.propTypes = {
    login: PropTypes.string.isRequired,
    setSelectedLogin: PropTypes.func.isRequired
};

export default LoginSuggestOption;
