import React from 'react';
import PropTypes from 'prop-types';

function ServicesIcons({servicesList}) {
    return (
        <ul className='services__icons'>
            {servicesList.map((service) => (
                <li className='service__icon' key={service}>
                    <span className={`icon icon-${service}`} />
                </li>
            ))}
        </ul>
    );
}

ServicesIcons.propTypes = {
    servicesList: PropTypes.array.isRequired
};

export default ServicesIcons;
