/* eslint-disable no-invalid-this */

const MARGIN = 27;

export function addListenerIfNeeded() {
    if (this.props.services.length <= 5) {
        return;
    }

    this.firstIcon = document.querySelector('.scroll__icon');

    if (window.addEventListener) {
        this.refs.scroller.addEventListener('scroll', handleScroll.bind(this), false);
    } else {
        this.refs.scroller.attachEvent('onscroll', handleScroll.bind(this));
    }
}

export function handleScroll() {
    if (!this.props.services.length) {
        return;
    }

    const scrollLeft = this.refs.scroller.scrollLeft;
    const width = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    const elemWidth = this.firstIcon.offsetWidth || this.firstIcon.clientWidth;
    const scales = [];

    for (let i = 0; i < this.props.services.length; i++) {
        scales.push(
            Math.max(1 - Math.abs(width / 2 - (MARGIN + elemWidth / 2 + elemWidth * i - scrollLeft)) / (width / 2), 0.4)
        );
    }

    this.setState({scales});
}
