import React from 'react';
import PropTypes from 'prop-types';

import * as extracted from './services_icons_scroll.js';

export default class ServicesIconsScroll extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            scales: [0.4, 0.65, 1, 0.65, 0.4, 0.4]
        };
    }

    componentDidMount() {
        extracted.addListenerIfNeeded.call(this);
    }

    render() {
        const {services, staticPath, ua} = this.props;
        const type = ['MSIE', 'Edge'].indexOf(ua.BrowserName) !== -1 ? 'png' : 'svg';
        const diff = services.length > 5 ? [0, 0, -0.2] : [];

        return (
            <div className='list_row'>
                <div className='list_row__inner' ref='scroller'>
                    <ul className='services__icons'>
                        {services.map((service, ndx) => (
                            <li
                                className='scroll__icon'
                                key={ndx}
                                style={{transform: `scale(${this.state.scales[ndx] + (diff[ndx] || 0) || 1})`}}
                            >
                                <img src={`${staticPath}/i/services_icons/${service}.${type}`} />
                            </li>
                        ))}
                    </ul>
                </div>
                <div className='cloud cloud__left' />
                <div className='cloud cloud__right' />
            </div>
        );
    }
}

ServicesIconsScroll.propTypes = {
    services: PropTypes.array.isRequired,
    staticPath: PropTypes.string.isRequired,
    ua: PropTypes.object.isRequired
};
