import {GET_SUGGESTED_LOGINS, SET_SUGGESTION_VALIDATING_STATUS, CLEAR_SUGGESTED_LOGINS} from '../actions';

const initialState = {
    loginsList: [],
    isFetching: false,
    isValidating: false
};

export default function logins(state = initialState, action) {
    switch (action.type) {
        case GET_SUGGESTED_LOGINS: {
            return Object.assign({}, state, {
                loginsList: action.data.logins,
                isFetching: action.data.isFetching || false
            });
        }
        case SET_SUGGESTION_VALIDATING_STATUS: {
            return Object.assign({}, state, {
                isValidating: action.isValidating
            });
        }
        case CLEAR_SUGGESTED_LOGINS: {
            return Object.assign({}, state, {
                loginsList: []
            });
        }
        default:
            return state;
    }
}
