import {combineReducers} from 'redux';
import {TOGGLE_PHONE_CONFIRMATION} from '@blocks/registration/actions';
import signup from '@blocks/SignUp/reducers';
import tracks from '@blocks/reducers/tracks';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';
import fetchingStatus from './fetchingStatus';
import registrationErrors from './registrationErrors';
import logins from './logins';
import confirmPopupShow from './confirmPopupShow';
import phoneConfirmationVisible from './phoneConfirmationVisible';
import phoneConfirmation from './phoneConfirmation';
import form from '@blocks/reducers/form';
import phoneConfirm from '@blocks/reducers/phoneConfirm';
import {userEntryFlow} from '@blocks/UserEntryFlow/reducers';
import {accountsSuggest} from '@blocks/reducers/accountsSuggest';

const mainReducer = combineReducers({
    settings(state = {}) {
        return state;
    },
    footer(state = {langlist: []}) {
        return state;
    },
    common,
    captcha,
    fetchingStatus,
    registrationErrors,
    logins,
    isEulaConfirmPopupShow: confirmPopupShow,
    phoneConfirmationVisible,
    phoneConfirmation,
    form,
    metrics(state = {}) {
        return state;
    },
    isPhoneConfirmationOpened(state = false, action) {
        if (action.type === TOGGLE_PHONE_CONFIRMATION) {
            return action.isPhoneConfirmationOpened;
        }

        return state;
    },
    person(state = {}) {
        return state;
    },
    monitoring(state = {page: 'registration'}) {
        return state;
    },
    pageMessage(state = null) {
        return state;
    },
    registrationName(state = 'default') {
        return state;
    },
    isIconsExperiment(state = false) {
        return state;
    },
    isPhoneConfirmationExperiment(state = false) {
        return state;
    },
    additionalStep(state = {type: ''}) {
        return state;
    },
    experimentsList(state = {}) {
        return state;
    },
    social(state = {}) {
        return state;
    },
    customs(state = {}) {
        return state;
    },
    registrationType(state = 'default') {
        return state;
    },
    signup,
    tracks,
    phoneConfirm,
    accountsSuggest,
    userEntryFlow
});

export default mainReducer;
