import {
    UPDATE_PHONE_HINT_STATUS,
    UPDATE_PHONE_HINT_TEXT,
    UPDATE_PHONE_CODE_HINT_TEXT,
    UPDATE_PHONE_CODE_STATUS_AGAIN,
    UPDATE_PHONE_CODE_HINT_STATUS,
    UPDATE_PHONE_CONFIRMATION_CALL_NUMBER
} from '../actions';

const initialState = {
    isCodeSent: false,
    isCodeSentAgain: false,
    isNeedValidation: false,
    isPhoneHintShown: false,
    isCodeHintShown: false,
    hint: {
        title: i18n('Frontend.phone_hint_popup-title'),
        text: i18n('Frontend.phone_hint_popup-text')
    },
    codeHint: {}
};

export default function phoneConfirmation(state = initialState, action) {
    switch (action.type) {
        case UPDATE_PHONE_HINT_STATUS: {
            return Object.assign({}, state, {
                isPhoneHintShown: action.isShown
            });
        }
        case UPDATE_PHONE_HINT_TEXT: {
            return Object.assign({}, state, {
                hint: {
                    title: i18n('Frontend.phone_hint_popup-title'),
                    text: action.text
                }
            });
        }
        case UPDATE_PHONE_CODE_HINT_TEXT: {
            return Object.assign({}, state, {
                codeHint: action.hint
            });
        }
        case UPDATE_PHONE_CODE_STATUS_AGAIN: {
            return Object.assign({}, state, {
                isCodeSentAgain: action.status
            });
        }
        case UPDATE_PHONE_CODE_HINT_STATUS: {
            return Object.assign({}, state, {
                isCodeHintShown: action.isShown
            });
        }
        case UPDATE_PHONE_CONFIRMATION_CALL_NUMBER: {
            return Object.assign({}, state, {
                callingNumberTemplate: action.maskedPhoneNumberStr
            });
        }
        default:
            return state;
    }
}
