import './socialButtons.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import mapStateToProps from './mapStateToProps';
import {SHOW_SOCIAL_BTNS, SOCIAL_BTN_CLICK, SOCIAL_BTN_CHOSEN} from '@blocks/registration/metrics_constants';
import startSocialAuth from '@blocks/authv2/actions/startSocialAuth';
import metrics from '@blocks/metrics';

class SocialButtons extends Component {
    constructor(props) {
        super(props);

        this.registerSocial = this.registerSocial.bind(this);
    }

    componentDidMount() {
        const {isSocialBtnsShowed} = this.props;

        if (isSocialBtnsShowed) {
            metrics.send([SHOW_SOCIAL_BTNS]);
        }
    }

    registerSocial(event) {
        event.stopPropagation();
        const {dispatch} = this.props;
        const provider = event.currentTarget && (event.currentTarget.dataset || {}).provider;

        metrics.send([SOCIAL_BTN_CLICK, `${SOCIAL_BTN_CHOSEN} ${provider}`]);

        if (provider) {
            dispatch(
                startSocialAuth({
                    provider
                })
            );
        }
    }

    render() {
        const {isSocialBtnsShowed, providersList, lang, place} = this.props;
        const returnDisplayName = (names) => names[lang] || names.default;

        if (isSocialBtnsShowed) {
            return (
                <div
                    className={classnames('registration_social-btns', {
                        [`registration_social-btns__${place}`]: Boolean(place)
                    })}
                >
                    <h5>{i18n('_AUTH_.registration.social-title')}</h5>
                    <div className='registration_social-btns__wrapper'>
                        {providersList.map((provider) => (
                            <SocialBtn
                                key={provider.code}
                                onClickHandler={this.registerSocial}
                                provider={provider.code}
                                name={returnDisplayName(provider.display_name)}
                                isSmall={providersList.length > 2}
                            />
                        ))}
                    </div>
                </div>
            );
        }
        return null;
    }
}

export default connect(mapStateToProps)(SocialButtons);

SocialButtons.defaultProps = {
    providersList: [{code: 'vk', display_name: {default: 'ВКонтакте'}}],
    lang: 'ru'
};

SocialButtons.propTypes = {
    dispatch: PropTypes.func.isRequired,
    isSocialBtnsShowed: PropTypes.bool,
    providersList: PropTypes.array.isRequired,
    lang: PropTypes.string.isRequired,
    place: PropTypes.string
};

function SocialBtn({onClickHandler, provider, name, isSmall}) {
    return (
        <button
            onClick={onClickHandler}
            className={classnames(`registration__${provider}-btn`, {
                'registration__social-btn': !isSmall,
                'registration__social-btn_short': isSmall
            })}
            data-provider={provider}
        >
            <span className={`registration__${provider}-icon registration__provider-icon`} />
            <span className='registration__social-btn_text'>{name}</span>
        </button>
    );
}

SocialBtn.propTypes = {
    onClickHandler: PropTypes.func.isRequired,
    provider: PropTypes.string.isRequired,
    name: PropTypes.string.isRequired,
    isSmall: PropTypes.bool
};
