import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Spin} from '@components/Spin';

class SpinnerComponent extends Component {
    static mapStateToProps(state, ownProps) {
        const fetchingStatus = ownProps.fetchingStatus || state.fetchingStatus;

        return {
            fetchingStatus
        };
    }

    render() {
        const {isFetching} = this.props.fetchingStatus;

        return (
            <div className='fetching-block'>
                <Spin progress={isFetching} size='l' />
            </div>
        );
    }
}

SpinnerComponent.propTypes = {
    fetchingStatus: PropTypes.shape({
        isFetching: PropTypes.bool
    })
};

export default connect(SpinnerComponent.mapStateToProps)(SpinnerComponent);
