import {notifyPasswordCopied, updateTakeoutData} from './';

export default function copyToClipboard({elementId = 'copied-text'} = {}) {
    return (dispatch) => {
        try {
            const elToCopy = document.getElementById(elementId);

            elToCopy.select();
            document.execCommand('copy');
            dispatch(notifyPasswordCopied());
            setTimeout(() => {
                dispatch(notifyPasswordCopied());
            }, 2500);
        } catch (err) {
            dispatch(updateTakeoutData({field: 'copyError', value: true}));
        }
    };
}
