import api from '../../api';
import {updateTakeoutData, updateLoadingStatus, setLinkLoadingStatus, handleInternalError} from './';
import handleArchiveLink from '../components/DataInfoContent/handleArchiveLink';
import {saveActionForRepeat} from '../../common/actions';

export default function getArchiveData() {
    return (dispatch, getState) => {
        const {
            common: {csrf, uid}
        } = getState();

        const params = {
            csrf_token: csrf,
            uid
        };

        dispatch(setLinkLoadingStatus(true));
        dispatch(saveActionForRepeat(getArchiveData));
        dispatch(updateLoadingStatus());
        api.request('profile/get-archive-link', params)
            .done((response = {}) => {
                dispatch(setLinkLoadingStatus(false));
                dispatch(updateLoadingStatus());

                if (response.status !== 'ok') {
                    dispatch(handleInternalError());
                    return;
                }

                dispatch(
                    updateTakeoutData({
                        field: 'archiveUrl',
                        value: response.archiveUrl
                    })
                );
                handleArchiveLink(response.archiveUrl);
            })
            .fail((error) => {
                const errorArr = error.errors;
                const errorCode = Array.isArray(errorArr) ? errorArr[0] : '';

                dispatch(setLinkLoadingStatus(false));
                dispatch(updateLoadingStatus());

                if (errorCode === 'password.required') {
                    return;
                }

                if (errorCode === 'action.impossible') {
                    dispatch(
                        updateTakeoutData({
                            field: 'error',
                            value: i18n('TakeOut.getdata_url-error')
                        })
                    );
                    return;
                }

                dispatch(handleInternalError());
            });
    };
}
