import api from '../../api';
import {
    updateTakeoutData,
    updateLoadingStatus,
    setPasswordLoadingStatus,
    handleInternalError,
    togglePasswordVisibility
} from './';
import {saveActionForRepeat} from '../../common/actions';

export default function getArchiveData() {
    return (dispatch, getState) => {
        const {
            common: {csrf, uid}
        } = getState();

        const params = {
            csrf_token: csrf,
            uid
        };

        dispatch(setPasswordLoadingStatus(true));
        dispatch(updateLoadingStatus());
        dispatch(saveActionForRepeat(getArchiveData));
        api.request('profile/get-archive-password', params)
            .done((response = {}) => {
                dispatch(updateLoadingStatus());
                dispatch(setPasswordLoadingStatus(false));

                if (response.status !== 'ok' || !response.password) {
                    dispatch(handleInternalError());
                    return;
                }

                dispatch(
                    updateTakeoutData({
                        field: 'archivePassword',
                        value: response.password
                    })
                );
                dispatch(togglePasswordVisibility());
            })
            .fail((error) => {
                const errorArr = error.errors;
                const errorCode = Array.isArray(errorArr) ? errorArr[0] : '';

                dispatch(updateLoadingStatus());
                dispatch(setPasswordLoadingStatus(false));

                if (errorCode === 'password.required') {
                    return;
                }

                if (errorCode === 'action.impossible') {
                    dispatch(
                        updateTakeoutData({
                            field: 'error',
                            value: i18n('TakeOut.getdata_url-error')
                        })
                    );
                    return;
                }

                dispatch(handleInternalError());
            });
    };
}
