export const UPDATE_TAKEOUT_STATUS = 'UPDATE_TAKEOUT_STATUS';
export const TOGGLE_PASSWORD_VISIBILITY = 'TOGGLE_PASSWORD_VISIBILITY';
export const UPDATE_TAKEOUT_DATA = 'UPDATE_TAKEOUT_DATA';
export const UPDATE_LOADING_STATUS = 'UPDATE_LOADING_STATUS';
export const SET_PASSWORD_LOADING_STATUS = 'SET_PASSWORD_LOADING_STATUS';
export const SET_LINK_LOADING_STATUS = 'SET_LINK_LOADING_STATUS';
export const NOTIFY_PASSWORD_COPIED = 'NOTIFY_PASSWORD_COPIED';
export const NOTIFY_PASSWORD_COPIED_FAILED = 'NOTIFY_PASSWORD_COPIED_FAILED';

export function updateTakeoutStatus(status) {
    return {
        type: UPDATE_TAKEOUT_STATUS,
        status
    };
}

export function updateTakeoutData(data) {
    return {
        type: UPDATE_TAKEOUT_DATA,
        data
    };
}

export function togglePasswordVisibility() {
    return {
        type: TOGGLE_PASSWORD_VISIBILITY
    };
}

export function notifyPasswordCopied() {
    return {
        type: NOTIFY_PASSWORD_COPIED
    };
}

export function setPasswordLoadingStatus(isLoading) {
    return {
        isLoading,
        type: SET_PASSWORD_LOADING_STATUS
    };
}

export function setLinkLoadingStatus(isLoading) {
    return {
        isLoading,
        type: SET_LINK_LOADING_STATUS
    };
}

export function updateLoadingStatus() {
    return {
        type: UPDATE_LOADING_STATUS
    };
}

export function handleInternalError() {
    return updateTakeoutData({
        field: 'error',
        value: i18n('_AUTH_.avatar.error-internal') // Что-то пошло не так. Попробуйте обновить страницу
    });
}
