import api from '../../api';
import {updateTakeoutStatus, updateLoadingStatus, handleInternalError, updateTakeoutData} from './';

export default function requestDataArchive() {
    return (dispatch, getState) => {
        const onSuccess = () => {
            dispatch(updateTakeoutStatus('isBeingRequesting'));
            dispatch(
                updateTakeoutData({
                    field: 'error',
                    value: ''
                })
            );
        };
        const {
            common: {csrf, uid}
        } = getState();
        const params = {
            csrf_token: csrf,
            uid
        };

        dispatch(updateLoadingStatus());
        api.request('profile/request-data-archive', params)
            .done((response = {}) => (response.status === 'ok' ? onSuccess() : dispatch(handleInternalError())))
            .fail(({errors} = {}) => {
                const errorCode = Array.isArray(errors) && errors[0];

                return errorCode === 'action.not_required' ? onSuccess() : dispatch(handleInternalError());
            })
            .always(() => dispatch(updateLoadingStatus()));
    };
}
